IF EXISTS(SELECT * FROM sys.objects
	WHERE  object_id = OBJECT_ID(N'[dbo].[UFD_RC_ADM_CARTAO_MOV_EXTRATO]')
		   AND type IN(N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_RC_ADM_CARTAO_MOV_EXTRATO];

GO

--SELECT * FROM UFD_RC_ADM_CARTAO_MOV_EXTRATO (1,4,1,'2009-04-01','2009-08-10',0,1)  
CREATE FUNCTION [dbo].[UFD_RC_ADM_CARTAO_MOV_EXTRATO]
(@CD_EMP      INT
, @CD_ADMIN    INT
, @CD_GRP_ECON INT
, @DT_INI      DATETIME
, @DT_FIM      DATETIME
, @MODALIDADE  INT
, @TP_DT       INT --0 DATA DE EMISSAO 1- VENCIMENTO
)
RETURNS @LANC_EXTRATO TABLE
(CD_CTR          INT
, HIST_LANC       VARCHAR(100)
, DT_LANCTO       DATETIME
, VLR_SLD_INICIAL MONEY
, VLR_CRED        MONEY
, VLR_DEB         MONEY
, VLR_SLD         MONEY
, CD_FILIAL       INT
, MODALIDADE      INT
, CD_CTR_LOTE     INT
, FECHA_CARTAO    INT
)
AS
	 BEGIN
		 DECLARE @VLR_SLD MONEY;
		 DECLARE @VLR_SLD_ANT MONEY;
		 DECLARE @RS_MOV_CARTAO TABLE
(CD_CTR          INT
, HIST_LANC       VARCHAR(100)
, DT_LANC         DATETIME
, VLR_SLD_INICIAL MONEY
, VLR_CRED        MONEY
, VLR_DEB         MONEY
, VLR_SLD         MONEY
, FLAG_SLD_INI    INT
, CD_FILIAL       INT
, MODALIDADE      INT
, CD_CTR_LOTE     INT
, FECHA_CARTAO    INT
);
		 SET @VLR_SLD_ANT =
(
	SELECT
		   DBO.UFD_RC_ADM_CARTAO_MOV_SLD
		   (@CD_ADMIN, @CD_GRP_ECON, @DT_INI, @TP_DT, @MODALIDADE
		   )
);
		 INSERT INTO @RS_MOV_CARTAO
		 SELECT
				0 CD_CTR
			  , 'SALDO ANTERIOR'
			  , @DT_INI - 1 AS DT_LANC
			  , @VLR_SLD_ANT
			  , 0
			  , 0
			  , 0
			  , 1
			  , 0
			  , @MODALIDADE
			  , 0 AS CD_CTR_LOTE
			  , 0 AS FECHA_CARTAO
		 UNION ALL
		 SELECT
				RC_ADM_CARTAO_MOV.CD_CTR
			  , RC_ADM_CARTAO_MOV.HIST_LANC
			  , RC_ADM_CARTAO_MOV.DT_LANC
			  , 0
			  , VLR_LANC AS VLR_CRED
			  , 0 AS VLR_DEB
			  , 0
			  , FLAG_SLD_INI
			  , CD_FILIAL
			  , MODALIDADE
			  , ISNULL(RC_ADM_CARTAO_MOV_BAIXA.CD_CTR_LOTE, 0) AS CD_CTR_LOTE
			  , 0 AS FECHA_CARTAO
		 FROM
			 RC_ADM_CARTAO_MOV
			 LEFT OUTER JOIN RC_ADM_CARTAO_MOV_BAIXA ON RC_ADM_CARTAO_MOV.CD_CTR = RC_ADM_CARTAO_MOV_BAIXA.CD_CTR
		 WHERE   CD_CLI = @CD_ADMIN
				 AND CD_GRP_ECON = @CD_GRP_ECON
				 AND DT_LANC BETWEEN @DT_INI AND @DT_FIM
				 AND TP_LANC = 0
		 UNION ALL
		 SELECT
				RC_ADM_CARTAO_MOV.CD_CTR
			  , RC_ADM_CARTAO_MOV.HIST_LANC
			  , RC_ADM_CARTAO_MOV.DT_LANC
			  , 0
			  , 0 AS VLR_CRED
			  , VLR_LANC AS VLR_DEB
			  , 0
			  , FLAG_SLD_INI
			  , CD_FILIAL
			  , MODALIDADE
			  , 0 AS CD_CTR_LOTE
			  , ISNULL(RC_ADM_CARTAO_MOV_LOTE_RC_ADM_CARTAO_MOV.CD_CTR, 0) AS FECHA_CARTAO
		 FROM
			 RC_ADM_CARTAO_MOV
			 LEFT OUTER JOIN RC_ADM_CARTAO_MOV_LOTE_RC_ADM_CARTAO_MOV ON RC_ADM_CARTAO_MOV.CD_CTR = RC_ADM_CARTAO_MOV_LOTE_RC_ADM_CARTAO_MOV.CD_CTR
		 WHERE  CD_CLI = @CD_ADMIN
				AND CD_GRP_ECON = @CD_GRP_ECON
				AND DT_LANC BETWEEN @DT_INI AND @DT_FIM
				AND TP_LANC = 1
		 ORDER BY
				  DT_LANC
				, CD_CTR;
		 SET @VLR_SLD = @VLR_SLD_ANT;
		 UPDATE @RS_MOV_CARTAO
		   SET
			   @VLR_SLD = (@VLR_SLD + VLR_DEB) - VLR_CRED
			 , VLR_SLD = @VLR_SLD;
		 INSERT INTO @LANC_EXTRATO
		 SELECT
				CD_CTR
			  , HIST_LANC
			  , DT_LANC
			  , VLR_SLD_INICIAL
			  , VLR_CRED
			  , VLR_DEB
			  , VLR_SLD
			  , CD_FILIAL
			  , MODALIDADE
			  , CD_CTR_LOTE
			  , FECHA_CARTAO
		 FROM
			 @RS_MOV_CARTAO
		 ORDER BY
				  FLAG_SLD_INI DESC
				, DT_LANC
				, CD_CTR;
		 RETURN;
	 END;  
